//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PassthroughUseCase.h"
#import "ISO15693Command.h"
#import "Utils.h"

@implementation PassthroughUseCase: NSObject

int SRAM_WRITE_SIZE = 240;
int SRAM_READ_SIZE = 252;
int MAX_ITERATIONS = 80;

int readCounter = 0;
int writeCounter = 0;

int SRAM_LOOP_SIZE = 5;

NSMutableArray * sramDataToWrite;

unsigned char * responseTagStatus;
unsigned char * responseWriteSRAM;
unsigned char * responseRead;

ISO15693Command * finalCommandWriteSRAM;
NSMutableArray * sramDataRead;

NSString * textReadSRAM;
NSString * textDirection;
NSString * textLog;

NSMutableString *finalCommand;
bool stopLoopCase;

bool cmdStatus = false;

#pragma mark - sharedInstance
+ (PassthroughUseCase *) sharedInstance{
    static PassthroughUseCase *sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{ sharedInstance = [[PassthroughUseCase alloc] init]; });
    return sharedInstance;
}

#pragma mark - InitializeSRAMData
- (void)InitializeSRAMData:(void (^)(NSData *aData, NSString * text))success  onFailure : (void(^)(NSError *error))failure{
    sramDataToWrite = [[NSMutableArray alloc] initWithCapacity:SRAM_WRITE_SIZE];
    
    for (int i = 0; i < SRAM_WRITE_SIZE; i++){
        [sramDataToWrite addObject:[NSNumber numberWithInt:i]];
    }
    
    // Initialize SRAM data for RF->I2C mode, not possible to send the whole SRAM (256 bytes)
    // in a RF command because of the NFC API limitation,
    // thus the first 2 blocks of the SRAM will not be written and the final lenght is 250 bytes.
    NSMutableString *sb = [NSMutableString stringWithString:@""];
    finalCommand = [NSMutableString string];
    
    for (int i = 0; i < SRAM_WRITE_SIZE ; i++) {
        sramDataToWrite[i] = [NSNumber numberWithInt:i];
        if (i < SRAM_WRITE_SIZE - 1) {
            NSInteger value = [sramDataToWrite[i] integerValue];
            int integer =  value & 0xff;
            
            NSString *res = [NSString stringWithFormat:@"%0X", integer];
            NSString * first_string = [res uppercaseString];
            
            [sb appendString:@"0x"];
            [sb appendString:first_string];
            [sb appendString:@", "];
            
            [finalCommand appendFormat:@"%02x", i];
        } else if (i == SRAM_WRITE_SIZE - 1) {
            NSInteger value = [sramDataToWrite[i] integerValue];
            int integer =  value & 0xff;
            
            NSString *res = [NSString stringWithFormat:@"%0X", integer];
            NSString * first_string = [res uppercaseString];
            
            [sb appendString:@"0x"];
            [sb appendString:first_string];
            
            [finalCommand appendFormat:@"%02x", i];
        }
    }
    success(nil, [NSString stringWithString:sb]);
}

#pragma mark - SRAMLoop
- (void)SRAMLoop:(void (^)(NSData *aData, bool * isWrite ))success  onFailure : (void(^)(NSError *error))failure{
    NSString *finalCommandWriteSRAMStr = [NSString stringWithFormat:@"%@%@", cmd_writeSRAM, finalCommand];
    finalCommandWriteSRAM = [[ISO15693Command alloc]initWithData:finalCommandWriteSRAMStr];
    
    __block int iteration = 0;
    __block int writeCounter = 0;
    __block int readCounter = 0;
    __block bool execute = true;
    
    // Perform loop while it isn't cancelled and before MAX_ITERATIONS iterations
    while (execute && iteration < MAX_ITERATIONS){
        // Loop delay for demo flow
        [NSThread sleepForTimeInterval:0.1f];
        ISO15693Command *readTagStatus = [[ISO15693Command alloc] initWithData:cmd_readTagStatus];
        [[NTAG5_NFC_LIB sharedInstance] sendCommand: readTagStatus onSuccess:^(NSData *aData){
            if(aData.length < 1)
                execute = false;
            // Check if PT_TRANSFER_DIR == RF->I2C direction
            if([[Utils alloc] IsBitSet:aData position:0 index:2 ]){
                readCounter = 0;
                if (writeCounter < SRAM_LOOP_SIZE) {
                    //Check if SRAM_DATA_READY != 1, which means the I2C has read the SRAM
                    if(![[Utils alloc]IsBitSet:aData position:0 index:5 ]){
                        [[NTAG5_NFC_LIB sharedInstance] sendCommand: finalCommandWriteSRAM onSuccess:^(NSData *aData){
                            writeCounter++;
                            success(aData, TRUE);
                            if (writeCounter < SRAM_LOOP_SIZE)
                                iteration++;
                        } onFailure:^(NSError *error) {
                            NSLog(@"SRAMLoop error :\n%@", error.localizedDescription);
                        }];
                    }
                }
            }
            else{
                writeCounter = 0;
                if (readCounter < SRAM_LOOP_SIZE) {
                    //Check if SRAM_DATA_READY != 1, which means the I2C has read the SRAM
                    if([[Utils alloc] IsBitSet:aData position:0 index:5 ]){
                        ISO15693Command *readSRAM = [[ISO15693Command alloc] initWithData:cmd_readSRAM];
                        [[NTAG5_NFC_LIB sharedInstance] sendCommand: readSRAM onSuccess:^(NSData *aData){
                            execute = true;
                            readCounter++;
                            success(aData,FALSE);
                            if (readCounter < SRAM_LOOP_SIZE)
                                iteration++;
                            
                        } onFailure:^(NSError *error) {
                            NSLog(@"SRAMLoop error :\n%@", error.localizedDescription);
                        }];
                    }
                }
            }
        } onFailure:^(NSError *error) {
        }];
    }
    
    // Close NFC Session
    if( [[NTAG5_NFC_LIB sharedInstance] isConnect]){
        [[NTAG5_NFC_LIB sharedInstance] setMessage:@"Demo Finished!"];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {
            NSLog(@"SRAMLoop error :\n%@", error.localizedDescription);
        }];
    }
}

@end
